<?php if (get_field('promopanel_show','option')) { ?>
	<div class="promopanel transition">
		<div class="promopanel__title">
			<?php if (get_field('promopanel_title','option'))
				the_field('promopanel_title','option');
			else
				echo 'Promocje'; ?>
		</div>
		<div class="promopanel__content">
			<?php if (get_field('show_promo_apartments','option')) {
				$promo = new WP_Query(
					array(
						'post_type' => 'apartments',
						'orderby' => 'menu_order',
						'order' => 'ASC',
						'post_status' => 'publish',
						'posts_per_page' => -1,
						'meta_query' => array(
							array(
								'key' => 'status',
								'value' => '0_promo',
								'compare' => 'LIKE'
							)
						)
					)
				);
				wp_reset_postdata();
				if ( $promo->have_posts() ) { ?>
					<div id="carousel-promopanel" class="carousel slide promopanel__slider" data-ride="carousel">
						<div class="carousel-inner same-height" role="listbox">
							<?php $p = 0;
							while ( $promo->have_posts() ) { $promo->the_post();
								$terms = get_terms('apartment_category', array( 'parent' => 0 ) );
								if ($terms) $ap_term = array_pop($terms);
								$invest_cat = get_field('invest_cat',$ap_term);	
								$term = 'building_category_' . $invest_cat->term_id;
								$cat_banner = get_field('main_banner',$term); ?>
									<div class="promopanel__item item<?php if ($p == 0) echo ' active'; ?>">
										<?php $model_3d = get_field('model_3d');
										$images = get_field('gallery');
										$thumb_id = get_post_thumbnail_id($promo->ID); ?>
										<div class="relative marginbottom thumbnail-200 thumbnail-<?php if ($model_3d or $images) echo 'contain'; else echo 'cover'; ?>" style="background-image:url(<?php if ($model_3d) echo $model_3d['url']; elseif (has_post_thumbnail()) echo wp_get_attachment_url($thumb_id); elseif ($images[0]) echo $images[0]['sizes']['large']; elseif ($cat_banner) echo $cat_banner['sizes']['large']; else echo get_template_directory_uri() . '/includes/img/page-thumb.jpg'; ?>);">
											<a href="<?php the_permalink(); ?>" class="hover-link link-absolute"></a>
										</div>
										<p><strong><?php if (get_field('promo_title')) the_field('promo_title'); else echo get_the_title() . ' - ' . $invest_cat->name; ?></strong></p>
										<?php the_field('promo_text'); ?>
										<a href="<?php the_permalink(); ?>" class="btn btn-mini btn-default">Zobacz</a>
									</div>
								<?php $p++;
							} ?>
						</div>
						<a class="left carousel-control" href="#carousel-promopanel" role="button" data-slide="prev">
							<span class="glyphicon glyphicon-menu-left" aria-hidden="true"></span>
							<span class="sr-only">Wstecz</span>
						</a>
						<a class="right carousel-control" href="#carousel-promopanel" role="button" data-slide="next">
							<span class="glyphicon glyphicon-menu-right" aria-hidden="true"></span>
							<span class="sr-only">Dalej</span>
						</a>
					</div>
				<?php }
				wp_reset_query();
			} elseif(  have_rows('promo_list','option') ) { ?>
				<div id="carousel-promopanel" class="carousel slide promopanel__slider" data-ride="carousel" data-interval="6000">
					<div class="carousel-inner same-height" role="listbox">
						<?php $p = 0;
						while ( have_rows('promo_list','option') ) { the_row(); ?>
							<div class="promopanel__item item<?php if ($p == 0) echo ' active';?>">
								<?php $promo_img = get_sub_field('promo_img'); ?>
								<div class="relative marginbottom thumbnail-200 thumbnail-cover" style="background-image:url(<?php echo $promo_img['sizes']['large']; ?>);">
									<?php if (get_sub_field('promo_link')) { ?>
										<a href="<?php the_sub_field('promo_link'); ?>" class="hover-link link-absolute" target="_blank"></a>
									<?php } ?>
								</div>
								<?php if (get_sub_field('promo_title')) { ?>
									<h4><?php the_sub_field('promo_title'); ?></h4>
								<?php } ?>
								<?php the_sub_field('promo_text'); ?>
								<?php if (get_sub_field('promo_link')) { ?>
									<a href="<?php the_sub_field('promo_link'); ?>" class="btn btn-mini btn-default" target="_blank">Zobacz</a>
								<?php } ?>
							</div>
						<?php $p++;
						} ?>
					</div>
					<?php if (count(get_field('promo_list','option')) > 1) { ?>
						<a class="left carousel-control" href="#carousel-promopanel" role="button" data-slide="prev">
							<span class="glyphicon glyphicon-menu-left" aria-hidden="true"></span>
							<span class="sr-only">Wstecz</span>
						</a>
						<a class="right carousel-control" href="#carousel-promopanel" role="button" data-slide="next">
							<span class="glyphicon glyphicon-menu-right" aria-hidden="true"></span>
							<span class="sr-only">Dalej</span>
						</a>
					<?php } ?>
				</div>
			<?php } ?>
		</div>
	</div>
<?php } ?>